/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: SercosIII_SlIDN_Public.h 52410 2015-03-20 13:18:50Z DenisJ            $

   Description:
    SERCOSIII Slave IDN Task

    Includes following functions:

   Changes:

     Date          Description
     ---------------------------------------------------------------------------
     2009-08-05    Created
*******************************************************************************/
/**
 * @file SercosIII_SlIDN_Public.h
 *  SercosIII_Sl IDN - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 *
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__TLR_PACKED_PRE</code>
 * and <code>__TLR_PACKED_POST</code> have to be added with the structural definition
 * in addition.
 */

#ifndef __SERCOSIII_SLIDN_PUBLIC_H
#define __SERCOSIII_SLIDN_PUBLIC_H


#define SIII_SL_IDN_QUEUE_NAME "QUE_S3_SL_IDN"

#define SIII_SL_IDN_CMD_WRITE_REQ                          0x00005A00
#define SIII_SL_IDN_CMD_WRITE_CNF                          0x00005A01

#define SIII_SL_IDN_CMD_WRITE_IND                          0x00005A00
#define SIII_SL_IDN_CMD_WRITE_RES                          0x00005A01

#define SIII_SL_IDN_CMD_READ_REQ                           0x00005A02
#define SIII_SL_IDN_CMD_READ_CNF                           0x00005A03

#define SIII_SL_IDN_CMD_READ_IND                           0x00005A02
#define SIII_SL_IDN_CMD_READ_RES                           0x00005A03

/* IDN commands */

#define SIII_SL_IDN_CMD_CREATE_IDN_REQ                     0x00005A40
#define SIII_SL_IDN_CMD_CREATE_IDN_CNF                     0x00005A41

#define SIII_SL_IDN_CMD_DELETE_IDN_REQ                     0x00005A42
#define SIII_SL_IDN_CMD_DELETE_IDN_CNF                     0x00005A43

#define SIII_SL_IDN_CMD_REGISTER_IDN_NOTIFY_REQ            0x00005A44
#define SIII_SL_IDN_CMD_REGISTER_IDN_NOTIFY_CNF            0x00005A45

#define SIII_SL_IDN_CMD_UNREGISTER_IDN_NOTIFY_REQ          0x00005A46
#define SIII_SL_IDN_CMD_UNREGISTER_IDN_NOTIFY_CNF          0x00005A47

#define SIII_SL_IDN_CMD_REGISTER_UNDEFINED_NOTIFY_REQ      0x00005A48
#define SIII_SL_IDN_CMD_REGISTER_UNDEFINED_NOTIFY_CNF      0x00005A49

#define SIII_SL_IDN_CMD_UNREGISTER_UNDEFINED_NOTIFY_REQ    0x00005A4A
#define SIII_SL_IDN_CMD_UNREGISTER_UNDEFINED_NOTIFY_CNF    0x00005A4B

#define SIII_SL_IDN_CMD_SET_IDN_NAME_REQ                   0x00005A4C
#define SIII_SL_IDN_CMD_SET_IDN_NAME_CNF                   0x00005A4D

#define SIII_SL_IDN_CMD_SET_IDN_UNIT_REQ                   0x00005A4E
#define SIII_SL_IDN_CMD_SET_IDN_UNIT_CNF                   0x00005A4F

#define SIII_SL_IDN_CMD_SET_DATA_STATUS_VALID_REQ          0x00005A50
#define SIII_SL_IDN_CMD_SET_DATA_STATUS_VALID_CNF          0x00005A51

#define SIII_SL_IDN_CMD_SET_DATA_STATUS_INVALID_REQ        0x00005A52
#define SIII_SL_IDN_CMD_SET_DATA_STATUS_INVALID_CNF        0x00005A53

#define SIII_SL_IDN_CMD_MODIFY_MIN_MAX_REQ                 0x00005A54
#define SIII_SL_IDN_CMD_MODIFY_MIN_MAX_CNF                 0x00005A55

/***************************************************************************************/
/* public, packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(SIII_SL_IDN_PUBLIC)
#endif

/* definitions for bElement */
#define SIII_SL_IDN_ELEMENT_DATASTATUS               1
#define SIII_SL_IDN_ELEMENT_NAME                     2
#define SIII_SL_IDN_ELEMENT_ATTRIBUTE                3
#define SIII_SL_IDN_ELEMENT_UNIT                     4
#define SIII_SL_IDN_ELEMENT_MINIMUM_VALUE            5
#define SIII_SL_IDN_ELEMENT_MAXIMUM_VALUE            6
#define SIII_SL_IDN_ELEMENT_OPDATA                   7

/* definitions for usDataStatus */
#define MSK_SIII_SL_IDN_DATA_STATUS_OPDATA_INVALID               0x0100

#define MSK_SIII_SL_IDN_DATA_STATUS_COMMAND_ERROR                0x0008
#define MSK_SIII_SL_IDN_DATA_STATUS_COMMAND_NOT_EXECUTED         0x0004
#define MSK_SIII_SL_IDN_DATA_STATUS_COMMAND_EXECUTION_ENABLED    0x0002
#define MSK_SIII_SL_IDN_DATA_STATUS_COMMAND_SET                  0x0001

/* definitions for ulAttribute */
#define MSK_SIII_SL_IDN_ATTR_OPDATA_WRITE_PROTECTED_IN_CP4       0x40000000
#define MSK_SIII_SL_IDN_ATTR_OPDATA_WRITE_PROTECTED_IN_CP3       0x20000000
#define MSK_SIII_SL_IDN_ATTR_OPDATA_WRITE_PROTECTED_IN_CP2       0x10000000

#define MSK_SIII_SL_IDN_ATTR_DECIMAL_PLACEMENT                   0x0F000000
#define SRT_SIII_SL_IDN_ATTR_DECIMAL_PLACEMENT                   24

#define MSK_SIII_SL_IDN_ATTR_DISPLAY_FORMAT                      0x00700000
#define SRT_SIII_SL_IDN_ATTR_DISPLAY_FORMAT                      20
#define VAL_SIII_SL_IDN_ATTR_DISPLAY_FORMAT_BINARY               0x00000000
#define VAL_SIII_SL_IDN_ATTR_DISPLAY_FORMAT_UNSIGNED_DECIMAL     0x00100000
#define VAL_SIII_SL_IDN_ATTR_DISPLAY_FORMAT_SIGNED_DECIMAL       0x00200000
#define VAL_SIII_SL_IDN_ATTR_DISPLAY_FORMAT_UNSIGNED_HEXADECIMAL 0x00300000
#define VAL_SIII_SL_IDN_ATTR_DISPLAY_FORMAT_TEXT                 0x00400000
#define VAL_SIII_SL_IDN_ATTR_DISPLAY_FORMAT_IDN                  0x00500000
#define VAL_SIII_SL_IDN_ATTR_DISPLAY_FORMAT_FLOATING_POINT       0x00600000
#define VAL_SIII_SL_IDN_ATTR_DISPLAY_FORMAT_DATE_AND_TIME        0x00700000

#define MSK_SIII_SL_IDN_ATTR_OPDATA_IS_PROC_CMD                  0x00080000

#define MSK_SIII_SL_IDN_ATTR_DATA_LENGTH                         0x00070000
#define SRT_SIII_SL_IDN_ATTR_DATA_LENGTH                         16
#define VAL_SIII_SL_IDN_ATTR_DATA_LENGTH_RESERVED0               0x00000000
#define VAL_SIII_SL_IDN_ATTR_IDN_IS_LIST                         0x00040000
#define VAL_SIII_SL_IDN_ATTR_DATA_LENGTH_TWO_BYTE                0x00010000
#define VAL_SIII_SL_IDN_ATTR_DATA_LENGTH_FOUR_BYTE               0x00020000
#define VAL_SIII_SL_IDN_ATTR_DATA_LENGTH_EIGHT_BYTE              0x00030000
#define VAL_SIII_SL_IDN_ATTR_DATA_LENGTH_ONE_BYTE_LIST           0x00040000
#define VAL_SIII_SL_IDN_ATTR_DATA_LENGTH_TWO_BYTE_LIST           0x00050000
#define VAL_SIII_SL_IDN_ATTR_DATA_LENGTH_FOUR_BYTE_LIST          0x00060000
#define VAL_SIII_SL_IDN_ATTR_DATA_LENGTH_EIGHT_BYTE_LIST         0x00070000

#define VAL_SIII_SL_IDN_NUM_POSSIBLE_ENTRIES             20
#define VAL_SIII_SL_IDN_ATTR_LENGTH_LIST_HEADER              4

#define MSK_SIII_SL_IDN_ATTR_SCALING                             0x0000FFFF
#define SRT_SIII_SL_IDN_ATTR_SCALING                             0

/* additional definitions */
#define MSK_SIII_SL_IDN_ATTR_DATA_LENGTH_IS_LIST                 0x00040000



#define SIII_SL_IDN_NUM_READWRITE_DATA_BYTES                     1024

#ifndef SIII_SL_MAXIMUM_NUMBER_IDNS_IN_S_0_0017
/* value was 16384 but this seems very much */
#define SIII_SL_MAXIMUM_NUMBER_IDNS_IN_S_0_0017                  4*(4+2000) /* maximum of 2000 IDNs in S-0-0017 */
#endif


/* help definitions */
#define SIII_SL_IDN_TYPE_MASK 0x00008000
#define SIII_SL_IDN_TYPE_P    0x00008000
#define SIII_SL_IDN_TYPE_S    0x00000000

#define SIII_SL_IDN(type, set, idn, si, se)         \
                (SIII_SL_IDN_TYPE_##type |          \
                 ((set & 0x7) << 12) |              \
                 (idn & 4095) |                     \
                 ((si & 0xFF) << 24) |              \
                 ((se & 0xFF) << 16))

#define SIII_SL_GET_IDN_LOW_16BIT(x)    ((x) & 0xFFFF)
#define SIII_SL_GET_IDN_SI(x)           (((x) >> 24) & 0xFF)
#define SIII_SL_GET_IDN_SE(x)           (((x) >> 16) & 0xFF)

/******************************************************************************
 * Packet:  SIII_SL_IDN_CMD_WRITE_REQ/SIII_SL_IDN_CMD_WRITE_CNF
 *          SIII_SL_IDN_CMD_WRITE_IND/SIII_SL_IDN_CMD_WRITE_RES
 */

/* request packet */
#define SIII_SL_IDN_WRITE_REQ_MIN_SIZE ((unsigned long)(((SIII_SL_IDN_WRITE_REQ_DATA_T*)0)->abData))

typedef __TLR_PACKED_PRE struct SIII_SL_IDN_WRITE_REQ_DATA_Ttag
{
  TLR_UINT32  ulIdn;
  TLR_UINT8   bSlaveIdx;
  TLR_UINT8   bDataBlockElement;
  TLR_UINT16  usTotalLength;
  TLR_UINT8   abData[SIII_SL_IDN_NUM_READWRITE_DATA_BYTES];
} __TLR_PACKED_POST SIII_SL_IDN_WRITE_REQ_DATA_T;

typedef struct SIII_SL_IDN_WRITE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_IDN_WRITE_REQ_DATA_T                      tData;
} SIII_SL_IDN_WRITE_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_WRITE_CNF_DATA_Ttag
{
  TLR_UINT32  ulIdn;
  TLR_UINT8   bSlaveIdx;
  TLR_UINT8   bDataBlockElement;
} __TLR_PACKED_POST SIII_SL_IDN_WRITE_CNF_DATA_T;

typedef struct SIII_SL_IDN_WRITE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_IDN_WRITE_CNF_DATA_T                      tData;
} SIII_SL_IDN_WRITE_CNF_T;


/* indication packet */
#define SIII_SL_IDN_WRITE_IND_MIN_SIZE ((unsigned long)(((SIII_SL_IDN_WRITE_IND_DATA_T*)0)->abData))

typedef SIII_SL_IDN_WRITE_REQ_DATA_T   SIII_SL_IDN_WRITE_IND_DATA_T;
typedef SIII_SL_IDN_WRITE_REQ_T        SIII_SL_IDN_WRITE_IND_T;

/* response packet */

typedef SIII_SL_IDN_WRITE_CNF_T SIII_SL_IDN_WRITE_RES_T;

/* packet union */
typedef union SIII_SL_IDN_WRITE_PCK_Ttag
{
  TLR_PACKET_HEADER_T      tHead;
  SIII_SL_IDN_WRITE_REQ_T  tReq;
  SIII_SL_IDN_WRITE_CNF_T  tCnf;
  SIII_SL_IDN_WRITE_IND_T  tInd;
  SIII_SL_IDN_WRITE_RES_T  tRes;
} SIII_SL_IDN_WRITE_PCK_T;


/******************************************************************************
 * Packet:  SIII_SL_IDN_CMD_READ_REQ/SIII_SL_IDN_CMD_READ_CNF
 *          SIII_SL_IDN_CMD_READ_IND/SIII_SL_IDN_CMD_READ_RES
 *
 *          ulSta must always be zero in SIII_SL_IDN_CMD_READ_IND/SIII_SL_IDN_CMD_READ_REQ otherwise the transfer is aborted
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_READ_REQ_DATA_Ttag
{
  TLR_UINT32  ulIdn;
  TLR_UINT8   bSlaveIdx;
  TLR_UINT8   bDataBlockElement;
} __TLR_PACKED_POST SIII_SL_IDN_READ_REQ_DATA_T;

typedef struct SIII_SL_IDN_READ_REQ_Ttag
{
  TLR_PACKET_HEADER_T                        tHead;
  SIII_SL_IDN_READ_REQ_DATA_T                tData;
} SIII_SL_IDN_READ_REQ_T;

/* confirmation packet */
#define SIII_SL_IDN_READ_CNF_MIN_SIZE ((unsigned long)(((SIII_SL_IDN_READ_CNF_DATA_T*)0)->abData))

typedef __TLR_PACKED_PRE struct SIII_SL_IDN_READ_CNF_DATA_Ttag
{
  TLR_UINT32  ulIdn;
  TLR_UINT8   bSlaveIdx;
  TLR_UINT8   bDataBlockElement;
  TLR_UINT16  usTotalLength;
  TLR_UINT8   abData[SIII_SL_IDN_NUM_READWRITE_DATA_BYTES];
} __TLR_PACKED_POST SIII_SL_IDN_READ_CNF_DATA_T;

typedef struct SIII_SL_IDN_READ_CNF_Ttag
{
  TLR_PACKET_HEADER_T                        tHead;
  SIII_SL_IDN_READ_CNF_DATA_T                tData;
} SIII_SL_IDN_READ_CNF_T;


/* indication packet */
typedef SIII_SL_IDN_READ_REQ_DATA_T  SIII_SL_IDN_READ_IND_DATA_T;
typedef SIII_SL_IDN_READ_REQ_T       SIII_SL_IDN_READ_IND_T;

/* response packet */
#define SIII_SL_IDN_READ_RES_MIN_SIZE ((unsigned long)(((SIII_SL_IDN_READ_RES_DATA_T*)0)->abData))

typedef SIII_SL_IDN_READ_CNF_DATA_T SIII_SL_IDN_READ_RES_DATA_T;
typedef SIII_SL_IDN_READ_CNF_T SIII_SL_IDN_READ_RES_T;

/* packet union */
typedef union SIII_SL_IDN_READ_PCK_Ttag
{
  TLR_PACKET_HEADER_T      tHead;
  SIII_SL_IDN_READ_REQ_T   tReq;
  SIII_SL_IDN_READ_CNF_T   tCnf;
  SIII_SL_IDN_READ_IND_T   tInd;
  SIII_SL_IDN_READ_RES_T   tRes;
} SIII_SL_IDN_READ_PCK_T;


/**************************************
 * Sum packet of all Read / Write functions
 */
typedef union SIII_SL_IDN_READWRITE_PCK_Ttag
{
  TLR_PACKET_HEADER_T      tHead;

  SIII_SL_IDN_WRITE_REQ_T  tWriteReq;
  SIII_SL_IDN_WRITE_CNF_T  tWriteCnf;
  SIII_SL_IDN_WRITE_IND_T  tWriteInd;
  SIII_SL_IDN_WRITE_RES_T  tWriteRes;

  SIII_SL_IDN_READ_REQ_T   tReadReq;
  SIII_SL_IDN_READ_CNF_T   tReadCnf;
  SIII_SL_IDN_READ_IND_T   tReadInd;
  SIII_SL_IDN_READ_RES_T   tReadRes;
} SIII_SL_IDN_READWRITE_PCK_T;

/******************************************************************************
 * Packet:  SIII_SL_IDN_CMD_CREATE_IDN_REQ/SIII_SL_IDN_CMD_CREATE_IDN_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_CREATE_IDN_REQ_DATA_Ttag
{
  /* unfragmentable part */
  TLR_UINT32                              ulIdn;
  TLR_UINT8                               bSlaveIdx;
  TLR_UINT8                               bValueInfo;
  TLR_UINT16                              usMaxNameLength;      /* allocated memory for name, up to 60 bytes */
  TLR_UINT16                              usMaxUnitLength;      /* allocated memory for unit, up to 60 bytes */
  TLR_UINT16                              usMaxListDataSize;    /* in bytes only valid on List types (byte length including list header) */
  TLR_UINT32                              ulAttribute;
  TLR_UINT32                              ulTotalLength;        /* total length of data stored in abData */
  /* fragmentable part */
  TLR_UINT8                               abData[1];
} __TLR_PACKED_POST SIII_SL_IDN_CREATE_IDN_REQ_DATA_T;

#define SIII_SL_IDN_CREATE_IDN_MIN_DATA_SIZE (sizeof(SIII_SL_IDN_CREATE_IDN_REQ_DATA_T) - sizeof(((SIII_SL_IDN_CREATE_IDN_REQ_DATA_T*)0)->abData))

/* following values are appended in order of their definition to abData (DATASTATUS, NAME, UNIT, MINIMUM, MAXIMUM, VALUE) */
#define MSK_SIII_SL_IDN_CREATE_IDN_VALUE_INFO_DATASTATUS  0x01    /* initial value */
#define MSK_SIII_SL_IDN_CREATE_IDN_VALUE_INFO_NAME        0x02
#define MSK_SIII_SL_IDN_CREATE_IDN_VALUE_INFO_UNIT        0x04
#define MSK_SIII_SL_IDN_CREATE_IDN_VALUE_INFO_MINIMUM     0x08
#define MSK_SIII_SL_IDN_CREATE_IDN_VALUE_INFO_MAXIMUM     0x10
#define MSK_SIII_SL_IDN_CREATE_IDN_VALUE_INFO_VALUE       0x20

typedef struct SIII_SL_IDN_CREATE_IDN_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  SIII_SL_IDN_CREATE_IDN_REQ_DATA_T       tData;
} SIII_SL_IDN_CREATE_IDN_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_CREATE_IDN_CNF_DATA_Ttag
{
  TLR_UINT32                              ulIdn;
  TLR_UINT8                               bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_CREATE_IDN_CNF_DATA_T;

typedef struct SIII_SL_IDN_CREATE_IDN_CNF_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  SIII_SL_IDN_CREATE_IDN_CNF_DATA_T       tData;
} SIII_SL_IDN_CREATE_IDN_CNF_T;

/******************************************************************************
 * Packet:  SIII_SL_IDN_CMD_DELETE_IDN_REQ/SIII_SL_IDN_CMD_DELETE_IDN_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_DELETE_IDN_REQ_DATA_Ttag
{
  TLR_UINT32                                ulIdn;
  TLR_UINT8                                 bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_DELETE_IDN_REQ_DATA_T;

typedef struct SIII_SL_IDN_DELETE_IDN_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_SL_IDN_DELETE_IDN_REQ_DATA_T         tData;
} SIII_SL_IDN_DELETE_IDN_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_DELETE_IDN_CNF_DATA_Ttag
{
  TLR_UINT32                                ulIdn;
  TLR_UINT8                                 bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_DELETE_IDN_CNF_DATA_T;

typedef struct SIII_SL_IDN_DELETE_IDN_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_SL_IDN_DELETE_IDN_CNF_DATA_T         tData;
} SIII_SL_IDN_DELETE_IDN_CNF_T;


/******************************************************************************
 * Packet:  SIII_SL_IDN_CMD_REGISTER_IDN_NOTIFY_REQ/SIII_SL_IDN_CMD_REGISTER_IDN_NOTIFY_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_REGISTER_IDN_NOTIFY_REQ_DATA_Ttag
{
  TLR_UINT32                                  ulIdn;
  TLR_UINT8                                   bSlaveIdx;
  TLR_BOOLEAN8                                fReadNotify;
  TLR_BOOLEAN8                                fWriteNotify;
  TLR_BOOLEAN8                                fVirtualMode;     /* setting VirtualMode will always activate both flags above.
                                                                 * the internal OpData storage is disabled in that case.
                                                                 */
  TLR_BOOLEAN8                                fAttributeReadNotify; /* attribute is read (application can provide changing Write Protection flags that way)
                                                                     * NOTE: fill out the entire attribute correctly to be compatible with
                                                                     * future additions to the changeable bits in the attribute
                                                                     */
} __TLR_PACKED_POST SIII_SL_IDN_REGISTER_IDN_NOTIFY_REQ_DATA_T;

typedef struct SIII_SL_IDN_REGISTER_IDN_NOTIFY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_IDN_REGISTER_IDN_NOTIFY_REQ_DATA_T        tData;
} SIII_SL_IDN_REGISTER_IDN_NOTIFY_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_REGISTER_IDN_NOTIFY_CNF_DATA_Ttag
{
  TLR_UINT32                                  ulIdn;
  TLR_UINT8                                   bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_REGISTER_IDN_NOTIFY_CNF_DATA_T;

typedef struct SIII_SL_IDN_REGISTER_IDN_NOTIFY_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_IDN_REGISTER_IDN_NOTIFY_CNF_DATA_T        tData;
} SIII_SL_IDN_REGISTER_IDN_NOTIFY_CNF_T;

/******************************************************************************
 * Packet:  SIII_SL_IDN_CMD_UNREGISTER_IDN_NOTIFY_REQ/SIII_SL_IDN_CMD_UNREGISTER_IDN_NOTIFY_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_UNREGISTER_IDN_NOTIFY_REQ_DATA_Ttag
{
  TLR_UINT32                          ulIdn;
  TLR_UINT8                           bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_UNREGISTER_IDN_NOTIFY_REQ_DATA_T;

typedef struct SIII_SL_IDN_UNREGISTER_IDN_NOTIFY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  SIII_SL_IDN_UNREGISTER_IDN_NOTIFY_REQ_DATA_T        tData;
} SIII_SL_IDN_UNREGISTER_IDN_NOTIFY_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_UNREGISTER_IDN_NOTIFY_CNF_DATA_Ttag
{
  TLR_UINT32                          ulIdn;
  TLR_UINT8                           bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_UNREGISTER_IDN_NOTIFY_CNF_DATA_T;

typedef struct SIII_SL_IDN_UNREGISTER_IDN_NOTIFY_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  SIII_SL_IDN_UNREGISTER_IDN_NOTIFY_CNF_DATA_T        tData;
} SIII_SL_IDN_UNREGISTER_IDN_NOTIFY_CNF_T;

/******************************************************************************
 * Packet:  SIII_SL_IDN_CMD_REGISTER_UNDEFINED_NOTIFY_REQ/SIII_SL_IDN_CMD_REGISTER_UNDEFINED_NOTIFY_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_REGISTER_UNDEFINED_NOTIFY_REQ_DATA_Ttag
{
  TLR_UINT8                           bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_REGISTER_UNDEFINED_NOTIFY_REQ_DATA_T;

typedef struct SIII_SL_IDN_REGISTER_UNDEFINED_NOTIFY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  SIII_SL_IDN_REGISTER_UNDEFINED_NOTIFY_REQ_DATA_T    tData;
} SIII_SL_IDN_REGISTER_UNDEFINED_NOTIFY_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_REGISTER_UNDEFINED_NOTIFY_CNF_DATA_Ttag
{
  TLR_UINT8                           bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_REGISTER_UNDEFINED_NOTIFY_CNF_DATA_T;

typedef struct SIII_SL_IDN_REGISTER_UNDEFINED_NOTIFY_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  SIII_SL_IDN_REGISTER_UNDEFINED_NOTIFY_CNF_DATA_T    tData;
} SIII_SL_IDN_REGISTER_UNDEFINED_NOTIFY_CNF_T;

/******************************************************************************
 * Packet:  SIII_SL_IDN_CMD_UNREGISTER_UNDEFINED_NOTIFY_REQ/SIII_SL_IDN_CMD_UNREGISTER_UNDEFINED_NOTIFY_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_UNREGISTER_UNDEFINED_NOTIFY_REQ_DATA_Ttag
{
  TLR_UINT8                            bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_UNREGISTER_UNDEFINED_NOTIFY_REQ_DATA_T;

typedef struct SIII_SL_IDN_UNREGISTER_UNDEFINED_NOTIFY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  SIII_SL_IDN_UNREGISTER_UNDEFINED_NOTIFY_REQ_DATA_T  tData;
} SIII_SL_IDN_UNREGISTER_UNDEFINED_NOTIFY_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_UNREGISTER_UNDEFINED_NOTIFY_CNF_DATA_Ttag
{
  TLR_UINT8                            bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_UNREGISTER_UNDEFINED_NOTIFY_CNF_DATA_T;

typedef struct SIII_SL_IDN_UNREGISTER_UNDEFINED_NOTIFY_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  SIII_SL_IDN_UNREGISTER_UNDEFINED_NOTIFY_CNF_DATA_T  tData;
} SIII_SL_IDN_UNREGISTER_UNDEFINED_NOTIFY_CNF_T;

/******************************************************************************
 * Packet:  SIII_SL_IDN_CMD_SET_IDN_NAME_REQ/SIII_SL_IDN_CMD_SET_IDN_NAME_CNF (does not support fragmentation)
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_SET_IDN_NAME_REQ_DATA_Ttag
{
  TLR_UINT32    ulIdn;
  TLR_UINT8     bSlaveIdx;
  TLR_UINT8     szName[240];        /* the new name may be up to 240 bytes long */
} __TLR_PACKED_POST SIII_SL_IDN_SET_IDN_NAME_REQ_DATA_T;

#define SIII_SL_IDN_SET_IDN_NAME_REQ_MIN_SIZE     (5) /* the value starts at szName */

typedef struct SIII_SL_IDN_SET_IDN_NAME_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_IDN_SET_IDN_NAME_REQ_DATA_T               tData;
} SIII_SL_IDN_SET_IDN_NAME_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_SET_IDN_NAME_CNF_DATA_Ttag
{
  TLR_UINT32    ulIdn;
  TLR_UINT8     bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_SET_IDN_NAME_CNF_DATA_T;

typedef struct SIII_SL_IDN_SET_IDN_NAME_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_SL_IDN_SET_IDN_NAME_CNF_DATA_T               tData;
} SIII_SL_IDN_SET_IDN_NAME_CNF_T;

/******************************************************************************
 * Packet:  SIII_SL_IDN_CMD_SET_IDN_UNIT_REQ/SIII_SL_IDN_CMD_SET_IDN_UNIT_CNF (does not support fragmentation)
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_SET_IDN_UNIT_REQ_DATA_Ttag
{
  TLR_UINT32    ulIdn;
  TLR_UINT8     bSlaveIdx;
  TLR_UINT8     szUnit[48];        /* the new unit may be up to 48 bytes long */
} __TLR_PACKED_POST SIII_SL_IDN_SET_IDN_UNIT_REQ_DATA_T;

#define SIII_SL_IDN_SET_IDN_UNIT_REQ_MIN_SIZE     (5) /* the value starts at szUnit */

typedef struct SIII_SL_IDN_SET_IDN_UNIT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_SL_IDN_SET_IDN_UNIT_REQ_DATA_T      tData;
} SIII_SL_IDN_SET_IDN_UNIT_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_SET_IDN_UNIT_CNF_DATA_Ttag
{
  TLR_UINT32    ulIdn;
  TLR_UINT8     bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_SET_IDN_UNIT_CNF_DATA_T;

typedef struct SIII_SL_IDN_SET_IDN_UNIT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_SL_IDN_SET_IDN_UNIT_CNF_DATA_T           tData;
} SIII_SL_IDN_SET_IDN_UNIT_CNF_T;

/******************************************************************************
 * Packet:  SIII_SL_IDN_CMD_SET_DATA_STATUS_VALID_REQ/SIII_SL_IDN_CMD_SET_DATA_STATUS_VALID_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_SET_DATA_STATUS_VALID_REQ_DATA_Ttag
{
  TLR_UINT32        ulIdn;
  TLR_UINT8         bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_SET_DATA_STATUS_VALID_REQ_DATA_T;

typedef struct SIII_SL_IDN_SET_DATA_STATUS_VALID_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_SL_IDN_SET_DATA_STATUS_VALID_REQ_DATA_T    tData;
} SIII_SL_IDN_SET_DATA_STATUS_VALID_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_SET_DATA_STATUS_VALID_CNF_DATA_Ttag
{
  TLR_UINT32        ulIdn;
  TLR_UINT8         bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_SET_DATA_STATUS_VALID_CNF_DATA_T;

typedef struct SIII_SL_IDN_SET_DATA_STATUS_VALID_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_SL_IDN_SET_DATA_STATUS_VALID_CNF_DATA_T    tData;
} SIII_SL_IDN_SET_DATA_STATUS_VALID_CNF_T;

/******************************************************************************
 * Packet:  SIII_SL_IDN_CMD_SET_DATA_STATUS_INVALID_REQ/SIII_SL_IDN_CMD_SET_DATA_STATUS_INVALID_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_SET_DATA_STATUS_INVALID_REQ_DATA_Ttag
{
  TLR_UINT32        ulIdn;
  TLR_UINT8         bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_SET_DATA_STATUS_INVALID_REQ_DATA_T;

typedef struct SIII_SL_IDN_SET_DATA_STATUS_INVALID_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_SL_IDN_SET_DATA_STATUS_INVALID_REQ_DATA_T  tData;
} SIII_SL_IDN_SET_DATA_STATUS_INVALID_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_SET_DATA_STATUS_INVALID_CNF_DATA_Ttag
{
  TLR_UINT32        ulIdn;
  TLR_UINT8         bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_SET_DATA_STATUS_INVALID_CNF_DATA_T;

typedef struct SIII_SL_IDN_SET_DATA_STATUS_INVALID_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_SL_IDN_SET_DATA_STATUS_INVALID_CNF_DATA_T  tData;
} SIII_SL_IDN_SET_DATA_STATUS_INVALID_CNF_T;

/******************************************************************************
 * Packet:  SIII_SL_IDN_CMD_MODIFY_MIN_MAX_REQ/SIII_SL_IDN_CMD_MODIFY_MIN_MAX_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE union SIII_SL_IDN_MODIFY_MIN_MAX_REQ_DATA_VALUE_Ttag
{
  TLR_UINT8                                       bValue;
  TLR_UINT16                                      usValue;
  TLR_UINT32                                      ulValue;
  TLR_UINT64                                      ull64BitValue;
  TLR_UINT8                                       abData[8];
} __TLR_PACKED_POST SIII_SL_IDN_MODIFY_MIN_MAX_REQ_DATA_VALUE_T;

typedef __TLR_PACKED_PRE struct SIII_SL_IDN_MODIFY_MIN_MAX_REQ_DATA_Ttag
{
  TLR_UINT32                                      ulIdn;
  TLR_UINT8                                       bSlaveIdx;
  SIII_SL_IDN_MODIFY_MIN_MAX_REQ_DATA_VALUE_T     tMinimum;
  SIII_SL_IDN_MODIFY_MIN_MAX_REQ_DATA_VALUE_T     tMaximum;
} __TLR_PACKED_POST SIII_SL_IDN_MODIFY_MIN_MAX_REQ_DATA_T;

typedef struct SIII_SL_IDN_MODIFY_MIN_MAX_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_SL_IDN_MODIFY_MIN_MAX_REQ_DATA_T           tData;
} SIII_SL_IDN_MODIFY_MIN_MAX_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_SL_IDN_MODIFY_MIN_MAX_CNF_DATA_Ttag
{
  TLR_UINT32                                      ulIdn;
  TLR_UINT8                                       bSlaveIdx;
} __TLR_PACKED_POST SIII_SL_IDN_MODIFY_MIN_MAX_CNF_DATA_T;

typedef struct SIII_SL_IDN_MODIFY_MIN_MAX_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_SL_IDN_MODIFY_MIN_MAX_CNF_DATA_T           tData;
} SIII_SL_IDN_MODIFY_MIN_MAX_CNF_T;

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(SIII_SL_IDN_PUBLIC)
#endif


#endif
